define(['VarUtilityAuthorizationService'], function () {
	'use strict';

	describe('VAR Utility Authorization Service --', function () {
		var $scope,
			$http,
			$httpBackend,
			$q,
			$injector,
			service,
			localResourceDirectory,
			localResourceDirectoryServiceMock,
			localDeferred;

		beforeEach(function() {
			module('angularTemplateApp');

			// resourceDirectory returns a hash of keys to URL values for MAE resources
			localResourceDirectoryServiceMock = jasmine.createSpyObj('localResourceDirectoryService', ['fetch']);

			localResourceDirectory = {
				'rest-v1': '/rest/v1'
			};

			module(function($provide) {
				$provide.value('localResourceDirectoryService', localResourceDirectoryServiceMock);
			});

			inject(function($rootScope, _$http_, _$httpBackend_, _$q_, _$window_, _$location_, _$injector_, VarUtilityAuthorizationService) {
				$scope = $rootScope;
				$http = _$http_;
				$httpBackend = _$httpBackend_;
				$q = _$q_;
				$injector = _$injector_;
				service = VarUtilityAuthorizationService;

				var localResourceDeferred = $q.defer();
				localResourceDeferred.resolve(localResourceDirectory);
				localResourceDirectoryServiceMock.fetch.andReturn(localResourceDeferred.promise);

				$httpBackend.whenGET('resources.json').respond(localResourceDirectory);
				$httpBackend.whenGET(localResourceDirectory['oauth-info']).respond('200', {});
			});
		});

		describe('the service', function () {
			beforeEach(function () {
				localDeferred = $q.defer();
				localDeferred.resolve('success'); // general resolved/success promise
			});

			it('should have some commonly used methods defined', function () {
				// used in other parts of the app
				expect(service.isAuthorized).toBeDefined();
				expect(service.checkAuthorizedKey).toBeDefined();
			});

			it('should be able to authorize users', function () {
				$httpBackend.expectGET(localResourceDirectory['rest-v1']).respond(function (method, url, data, headers) {
					return [200, {}, {}, ''];
				});

				expect(service.isAuthorized()).toBe(false);

				service.checkAuthorizedKey();
				$scope.$digest();
				$httpBackend.flush();

				expect(localResourceDirectoryServiceMock.fetch).toHaveBeenCalled();
				expect(service.isAuthorized()).toBe(true);
			});

			it('should be able to confirm unauthorized users', function () {
				$httpBackend.expectGET(localResourceDirectory['rest-v1']).respond(function (method, url, data, headers) {
					return [404, {}, {}, ''];
				});

				expect(service.isAuthorized()).toBe(false);

				service.checkAuthorizedKey();
				$scope.$digest();
				$httpBackend.flush();

				expect(localResourceDirectoryServiceMock.fetch).toHaveBeenCalled();
				expect(service.isAuthorized()).toBe(false);
			});
		});
	});
});